<?php
define('timezone','Asia/Bahrain');
$dt = new DateTime();
$item_date=time();
$dt->setTimestamp($item_date);
$dt->setTimezone(new DateTimeZone(timezone));
$now = $dt->format('Y/m/d H:i');
$vtime = strtotime(date('Y/m/d H:i'));

$pagelink = "https://icfbahrainchapter.com/icw2021/";
$pagetitle = "ICF Bahrain Chapter - ICW 2022";
$pageimage = "https://icfbahrainchapter.com/icw2022/assets/images/ICW22_Facebook_EventBannerImage.jpeg";
$pagecontent = "ICF Bahrain Chapter, ICW 2022, International Coaching Week. Bahrain Coaches, Defying Challenging Times. Online Event Schedule and Registration Links.";
//$pagecontent1 = "ICF Bahrain Chapter, ICW 2021, International Coaching Week Event, ICW2021, Coaching, Bahrain Coaches";
?>
<!doctype html>
<html lang="en">

<head>

    <!--====== Required meta tags ======-->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!--====== Title ======-->
    <title><?php echo $pagetitle; ?></title>
    <meta name="title" content="<?php echo $pagetitle; ?>">
	<meta name="description" content="<?php echo $pagecontent; ?>">


    <!--====== Favicon Icon ======-->
    <link rel="shortcut icon" href="assets/favicon/favicon.png" type="image/png">

<link rel="apple-touch-icon" sizes="57x57" href="assets/favicon/apple-icon-57x57.png">
<link rel="apple-touch-icon" sizes="60x60" href="assets/favicon/apple-icon-60x60.png">
<link rel="apple-touch-icon" sizes="72x72" href="assets/favicon/apple-icon-72x72.png">
<link rel="apple-touch-icon" sizes="76x76" href="assets/favicon/apple-icon-76x76.png">
<link rel="apple-touch-icon" sizes="114x114" href="assets/favicon/apple-icon-114x114.png">
<link rel="apple-touch-icon" sizes="120x120" href="assets/favicon/apple-icon-120x120.png">
<link rel="apple-touch-icon" sizes="144x144" href="assets/favicon/apple-icon-144x144.png">
<link rel="apple-touch-icon" sizes="152x152" href="assets/favicon/apple-icon-152x152.png">
<link rel="apple-touch-icon" sizes="180x180" href="/apple-icon-180x180.png">
<link rel="icon" type="image/png" sizes="192x192"  href="assets/favicon/android-icon-192x192.png">
<link rel="icon" type="image/png" sizes="32x32" href="assets/favicon/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="96x96" href="assets/favicon/favicon-96x96.png">
<link rel="icon" type="image/png" sizes="16x16" href="assets/favicon/favicon-16x16.png">
<link rel="manifest" href="assets/favicon/manifest.json">
<meta name="msapplication-TileColor" content="#ffffff">
<meta name="msapplication-TileImage" content="assets/favicon/ms-icon-144x144.png">
<meta name="theme-color" content="#ffffff">

<!-- Google / Search Engine Tags -->
<meta itemprop="name" content="<?php echo $pagetitle; ?>">
<meta itemprop="description" content="<?php echo $pagecontent; ?>">
<meta itemprop="image" content="<?php echo $pageimage; ?>">

<!-- Facebook Meta Tags -->
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo $pagelink; ?>">
<meta property="og:title" content="<?php echo $pagetitle; ?>">
<meta property="og:description" content="<?php echo $pagecontent; ?>">
<meta property="og:image" content="<?php echo $pageimage; ?>">

<!-- Twitter Meta Tags -->
<meta name="twitter:card" content="summary_large_image">
<meta property="twitter:url" content="<?php echo $pagelink; ?>">
<meta name="twitter:title" content="<?php echo $pagetitle; ?>">
<meta name="twitter:description" content="<?php echo $pagecontent; ?>">
<meta name="twitter:image" content="<?php echo $pageimage; ?>">

<meta name="viewport" content="width=device-width, initial-scale=1">

    <!--====== Bootstrap css ======-->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">

    <!--====== Flaticon css ======-->
    <link rel="stylesheet" href="assets/css/flaticon.css">

    <!--====== Line Icons css ======-->
    <link rel="stylesheet" href="assets/css/LineIcons.css">

    <!--====== Animate css ======-->
    <link rel="stylesheet" href="assets/css/animate.css">

    <!--====== Magnific Popup css ======-->
    <link rel="stylesheet" href="assets/css/magnific-popup.css">

    <!--====== Slick css ======-->
    <link rel="stylesheet" href="assets/css/slick.css">

    <!--====== Default css ======-->
    <link rel="stylesheet" href="assets/css/default.css">

    <!--====== Style css ======-->
    <link rel="stylesheet" href="assets/css/style.css">

<style>
.ar { font-family: 'Almarai', sans-serif; }
</style>

</head>

<body>

    <!--====== PRELOADER PART START ======-->

    <div class="preloader">
        <div class="loader">
            <div class="ytp-spinner">
                <div class="ytp-spinner-container">
                    <div class="ytp-spinner-rotator">
                        <div class="ytp-spinner-left">
                            <div class="ytp-spinner-circle"></div>
                        </div>
                        <div class="ytp-spinner-right">
                            <div class="ytp-spinner-circle"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--====== PRELOADER PART ENDS ======-->

    <!--====== HEADER PART START ======-->

    <header class="header-area">
        <div class="navbar-area navbar-two">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <nav class="navbar navbar-expand-lg">
                            <a class="navbar-brand" href="index.php">
                                <img src="..\ICF_Bahrain_Horizontal_White.png" alt="Logo" height="45px">
                            </a>

                            <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarTwo" aria-controls="navbarTwo" aria-expanded="false" aria-label="Toggle navigation">
                                <span class="toggler-icon"></span>
                                <span class="toggler-icon"></span>
                                <span class="toggler-icon"></span>
                            </button>

                            <div class="collapse navbar-collapse sub-menu-bar" id="navbarTwo">
                                <ul class="navbar-nav m-auto">
                                    <li class="nav-item active">
                                        <a class="page-scroll" href="#home">ICW 2022</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="#event">Schedule</a>
                                    </li>
                                    <!--<li class="nav-item">
                                        <a class="page-scroll" href="#team">Speakers</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="#gallery">Gallery</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="#pricing">Pricing</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="page-scroll" href="#contact">Contact</a>
                                    </li>-->
                                </ul>
                            </div>

                            <div class="navbar-btn d-none d-sm-inline-block">
                                <!--<a class="main-btn" href="#">Join ICW 2021</a>-->
                                <!--<img src="assets/images/ICW2021Logo_StackedIcon_White-min.png" alt="" height="90px">-->
                                <h3 class="text-white"><i>ICW</i><br>2022</h3>
                            </div>
                        </nav> <!-- navbar -->
                    </div>
                </div> <!-- row -->
            </div> <!-- container -->
        </div>

        <div id="home" class="header-content-area bg_cover d-flex align-items-center" style="background: linear-gradient(135deg, rgba(38,55,147,1) 0%, rgba(7,167,193,1) 50%, rgba(251,187,61,1) 90%);">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-10">
                        
                        
                        <div class="header-content text-center">
                            <!--<h2 class="header-title">30 <sup>th</sup> May 2021</h2>-->
                            <img src="assets/images/ICW2021Logo_White_noDates-min.png" alt="" width="40%">
							<?php
							$startday = strtotime("2022/05/16 20:00");
							$current = strtotime(date($now));
							//$day   = strtotime("2021/05/30 20:30"); //event_date
							$endday= strtotime("2022/05/21 16:00");
							//day1: 2021/06/06 20:30 (1:30 hour)
							//day2: 2021/06/07 20:30 (1 hour)
							
							//day3: 2021/06/09 20:30 (1:30 hour)
							//day4: 2021/06/10 20:30 (1:30 hour) two session en & ar
							//day5: 2021/06/11 20:30 (1:30 hour)
							//day6: 2021/06/12 20:30 (1:30 hour)
							
//16th May 2022	Monday
$d1ten = "Business Side of Coaching Practise";
$d1tar = "(English)";
$d1la = "https://www.icf-events.org/icw/business-side-of-coaching-practise/";

//18th May 2022 Wed. (+2)
$d2ten = "(Arabic)";
$d2tar = "كيف أنظر إليك ككوتش";
$d2la = "https://www.icf-events.org/register/?event=c4ec76699c1d5c5e68a82e857f780a7e";

//21st May 2022	Saturday (+5)	
$d3ten = "Coaching for Youth";
$d3tar = "الكوتشينج للشباب";
$d3la = "https://www.icf-events.org/register/?event=2ea4b1c809e17872583c650c1d9ab075";

/*
//10th June 2021 Thursday (+4)
$d4ten = "Pro-Bono Coaching Session";
$d4tar = "جلسات الكوتشينج Pro-Bono";
$d4la = "https://www.icf-events.org/register/?event=5835ad72cfcc2971d82a4dd9bfc6eb0b"; //Arabic
$d4lb = "https://www.icf-events.org/register/?event=87d1ca369cfa28976375eb938ed3b3be"; //English

//11th June 2021 Friday (+5)
$d5ten = "Coaching in the Training Playground";
$d5tar = "الكوتشينج في ساحة التدريب";
$d5la = "https://www.icf-events.org/register/?event=c48ac84545e1cb7de6af030bcdb3eeee";
 
//12th June 2021 Saturday (+6)
$d6ten = "The Holistic Approach to Coaching Mastery";
$d6tar = "نهج الكوتشينج الشمولي لمستوى الماستر";
$d6la = "https://www.icf-events.org/register/?event=1c1ad6b9943db12a41a5cb5568e45cc0";
*/

/////////////////////////////////////////////////////////

if($current<$startday){$day=$startday;
//16th May 2022	Monday
$dten = "Business Side of Coaching Practise";
$dtar = "(English)";
$dla = "https://www.icf-events.org/icw/business-side-of-coaching-practise/";
}
//elseif(($current>=$startday) && ($current<($startday+(60*60*24)))){$day=$startday+(60*60*24);
elseif(($current>=($startday+(60*60*24))) && ($current<($startday+((60*60*24)*2)+3600))){$day=$startday+((60*60*24)*2)+3600;
//18th May 2022 Wed (+2)
$dten = "(Arabic)";
$dtar = "كيف أنظر إليك ككوتش";
$dla = "https://www.icf-events.org/register/?event=c4ec76699c1d5c5e68a82e857f780a7e";
}
//elseif(($current>=($startday+(60*60*24))) && ($current<($startday+((60*60*24)*3)))){$day=$startday+((60*60*24)*3);
elseif(($current>=($startday+((60*60*24)*4))) && ($current<($startday+((60*60*24)*5)))){$day=$startday+((60*60*24)*5);
//21st May 2022	Sat. (+5)
$dten = "Coaching for Youth";
$dtar = "الكوتشينج للشباب";
$dla = "https://www.icf-events.org/register/?event=2ea4b1c809e17872583c650c1d9ab075";	
}
/*
elseif(($current>=($startday+((60*60*24)*3))) && ($current<($startday+((60*60*24)*4)))){$day=$startday+((60*60*24)*4);
//10th June 2021 Thursday (+4)
$dten = "Pro- Bono Coaching Session";
$dtar = "جلسات الكوتشينج Pro- Bono";
$dla = "https://www.icf-events.org/register/?event=5835ad72cfcc2971d82a4dd9bfc6eb0b"; //Arabic
$dlb = "https://www.icf-events.org/register/?event=87d1ca369cfa28976375eb938ed3b3be"; //English
$both=1;
}
elseif(($current>=($startday+((60*60*24)*4))) && ($current<($startday+((60*60*24)*5)))){$day=$startday+((60*60*24)*5);
//11th June 2021 Friday (+5)
$dten = "Coaching in the Training Playground";
$dtar = "الكوتشينج في ساحة التدريب";
$dla = "https://www.icf-events.org/register/?event=c48ac84545e1cb7de6af030bcdb3eeee";	
}
elseif(($current>=($startday+((60*60*24)*5))) && ($current<($startday+((60*60*24)*6)))){$day=$startday+((60*60*24)*6);
//12th June 2021 Saturday (+6)
$dten = "The Holistic Approach to Coaching Mastery";
$dtar = "نهج الكوتشينج الشمولي لمستوى الماستر";
$dla = "https://www.icf-events.org/register/?event=1c1ad6b9943db12a41a5cb5568e45cc0";
}
*/
else{$day=$endday; $dla="https://icfbahrainchapter.com";}
						
							$datediff = $day - $current;
							$difference = floor($datediff/(60*60*24));
							
							//before events
							if($day>$current){ $showdate=date("l jS F, Y (h:i a)",$day); $eventtitle="Next Upcoming Event"; }
							
							//during events
							//if($difference==0){ 
							if($current>=$day && $current<=$endday){
							$showdate=date("l jS F, Y (h:i a)",$day);
							$eventtitle="Next Upcoming Event"; 
							}
							
							//after events
							if($endday<$current){ $eventtitle="ICW 2022 has ended. See you next Year."; }
							
							?>
                            <h3 class="sub-title pb-20"><?php echo $eventtitle; ?></h3><h4><font color="#FFB545"><?php echo $dten; ?><br><span class="ar"><?php echo $dtar; ?></span></font></b><?php //echo $showdate; ?>
                            
                            <!--<small><font color=white><?php //echo "<br>Day1: ".date("l jS F, Y (h:i a)",$startday)."<br>Day2: ".date("l jS F, Y (h:i a)",$startday+(60*60*(24)))."<br>Day3: ".date("l jS F, Y (h:i a)",$startday+(60*60*(24*3))); //echo "(".$day." - ".$current.") = ".$datediff." | "." End: ".$endday; //echo date("Y/m/d H:i",$day); ?></font></small>-->
                            
                            <br><br><font color=white><?php //echo date("l jS F, Y (h:i a)",$current); ?> <?php echo $showdate; ?></font> (BH Time)</h4>
							
							<div data-countdown="<?php echo date("Y/m/d H:i",$day-($current-$vtime)); ?>"></div>

<font color=white>
<small>(UTC)</small></font>
<!--
<font color=white>
<br>Event Time: <?php echo date("Y/m/d H:i",$day); ?><br>
BH Time: <?php echo date("Y/m/d H:i",$current); ?><br>
Visitor Time: <?php echo date("Y/m/d H:i",$vtime); ?> (UTC)<br>

Calc. Time: <?php echo date("Y/m/d H:i",$day-($current-$vtime)); ?> <br>

</font>
-->

                            <ul class="header-btn">
	                            <?php //if(!empty($both)){ ?>
                                <!--<li><a class="main-btn main-btn-2 page-scroll" href="#event<?php //echo $d4la; ?>">Register Now (AR)</a></li>
                                <li><a class="main-btn main-btn-2 page-scroll" href="#event<?php //echo $d4lb; ?>">Register Now (EN)</a></li>-->
                                <?php //}else{ ?>
                                <li><a class="main-btn main-btn-2 page-scroll" target="_blank" href="#event<?php //echo $dla; ?>">Register Now</a></li>
                                <?php //} ?>
                                <!--<li><a class="main-btn" href="#">Learn More</a></li>-->
                            </ul>
                        </div>  <!-- header content -->
                    </div>
                </div> <!-- row -->
            </div> <!-- container -->
        </div> <!-- header content -->
    </header>

    <!--====== HEADER PART ENDS ======-->

    <!--====== EVENT SCHEDULE PART START ======-->

    <section class="event-schedule pt-115 pb-130">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div id="event" class="section-title text-center">Strategic Partner<br>
	                    <img src="assets/images/BSTD-Logo-high-resolution_el864_1-min.jpg" height="95px">
                        <h2 class="title pt-70">SCHEDULE</h2>
                        <!--<p class="text">Lorem ipsum dolor sit amet, in quodsi vulputate pro. Ius illum vocent mediocritatem reiciendis odit sed, vero amet blanditiis cule dicta iriure at phaedrum.</p>-->
                    </div> <!-- section title -->
                </div>
            </div> <!-- row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="event-tab mt-60">
                        <ul class="nav justify-content-between align-items-center" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a id="day-1-tab" data-toggle="tab" href="#day-1" role="tab" aria-controls="day-1" aria-selected="false">
                                    <h4 class="nav-title">Event 1</h4>
                                    <span><?php echo date("d M, Y",$startday); ?></span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a id="day-2-tab" data-toggle="tab" href="#day-2" role="tab" aria-controls="day-2" aria-selected="false">
                                    <h4 class="nav-title">Event 2</h4>
                                    <span><?php echo date("d M, Y",$startday+(60*60*24)*3); ?></span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a id="day-3-tab" data-toggle="tab" href="#day-3" role="tab" aria-controls="day-3" aria-selected="false">
                                    <h4 class="nav-title">Event 3</h4>
                                    <span><?php echo date("d M, Y",$startday+(60*60*24)*4.8); //echo date("d M, Y",$startday+(60*60*24)*3); ?></span>
                                </a>
                            </li>
                            <!--<li class="nav-item">
                                <a id="day-4-tab" data-toggle="tab" href="#day-4" role="tab" aria-controls="day-4" aria-selected="false">
                                    <h4 class="nav-title">Day 4</h4>
                                    <span><?php echo date("d M, Y",$startday+(60*60*24)*4); ?></span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a id="day-5-tab" data-toggle="tab" href="#day-5" role="tab" aria-controls="day-5" aria-selected="false">
                                    <h4 class="nav-title">Day 5</h4>
                                    <span><?php echo date("d M, Y",$startday+(60*60*24)*5); ?></span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a id="day-5-tab" class="active" data-toggle="tab" href="#day-6" role="tab" aria-controls="day-6" aria-selected="true">
                                    <h4 class="nav-title">Day 6</h4>
                                    <span><?php echo date("d M, Y",$startday+(60*60*24)*6); ?></span>
                                </a>
                            </li>-->
                        </ul>
                        <div class="tab-content" id="myTabContent">
	                        
                            <div class="tab-pane fade" id="day-1" role="tabpanel" aria-labelledby="day-1-tab">
                                <div class="event-content pt-40">
                                    <div class="single-event d-md-flex mt-30">
                                        <div class="event-image">
                                            <img src="assets/images/icw2022-16may-event1.jpg" width="360px"  alt="Event">
                                        </div>
                                        <div class="event-content media-body">
                                            <h4 class="event-title"><?php echo $d1ten; ?></h4>
                                            <p class="text ar"><?php echo $d1tar; ?></p>
                                            <ul class="event-meta">
                                                <li>Start: 8.00 PM (Bahrain Time)</li>
                                                <li>Duration: 1:30 Hours</li>
                                                <!--<li>Free Event</li>-->
                                                <!--<li>Location: Hall 1 , Building A, Golden Street, Southafrica</li>-->
                                            </ul>
                                            <br><!-- <a class="main-btn main-btn-2" href="<?php echo $d1la; ?>">Register Now</a>--> Event Ended
                                        </div>
                                    </div> <!-- single event -->
                                </div> <!-- event content -->
                            </div>
                            
                            <div class="tab-pane fade" id="day-2" role="tabpanel" aria-labelledby="day-2-tab">
                                <div class="event-content pt-40">
                                    <div class="single-event d-md-flex mt-30">
                                        <div class="event-image">
                                            <img src="assets/images/1652811707031.jpeg" width="360px"  alt="Event">
                                        </div>
                                        <div class="event-content media-body">
                                            <h4 class="event-title"><?php echo $d2ten; ?></h4>
                                            <p class="text ar"><?php echo $d2tar; ?></p>
                                            <ul class="event-meta">
                                                <li>Start: 9.00 PM (Bahrain Time)</li>
                                                <li>Duration: 1 Hour</li>
                                                <!--<li>Free Event</li>-->
                                            </ul>
                                            <br><!--<a class="main-btn main-btn-2" href="<?php echo $d2la; ?>">Register Now</a>--> Event Ended
                                        </div>
                                    </div> 
                                </div> 
                            </div>
                            
                            <div class="tab-pane fade show active" id="day-3" role="tabpanel" aria-labelledby="day-3-tab">
                                <div class="event-content pt-40">
                                    <div class="single-event d-md-flex mt-30">
                                        <div class="event-image">
                                            <img src="assets/images/icw2022-21may-event3.jpg" width="360px"  alt="Event">
                                        </div>
                                        <div class="event-content media-body">
                                            <h4 class="event-title"><?php echo $d3ten; ?></h4>
                                            <p class="text ar"><?php echo $d3tar; ?></p>
                                            <ul class="event-meta">
                                                <li>Start: 4.00 PM (Bahrain Time)</li>
                                                <li>Duration: 1:30 Hours</li>
                                                <!--<li>Free Event</li>-->
                                            </ul>
                                            <br><!--<a class="main-btn main-btn-2" href="<?php echo $d3la; ?>">Register Now</a>--> Event Ended
                                        </div>
                                    </div> 
                                </div> 
                            </div>
                            
                            <!--<div class="tab-pane fade" id="day-4" role="tabpanel" aria-labelledby="day-4-tab">
                                <div class="event-content pt-40">
                                    <div class="single-event d-md-flex mt-30">
                                        <div class="event-image">
                                            <img src="../logos/ICF_Bahrain_Stacked_FullColor.png" width="125px"  alt="Event">
                                        </div>
                                        <div class="event-content media-body">
                                            <h4 class="event-title"><?php echo $d4ten; ?></h4>
                                            <p class="text ar"><?php echo $d4tar; ?></p>
                                            <ul class="event-meta">
                                                <li>Start: 8.30 PM (Bahrain Time)</li>
                                                <li>Duration: 1:30 Hours</li>
                                                <li>Free Event</li>
                                            </ul>
                                            <br><a class="main-btn main-btn-2" href="<?php //echo $d4la; ?>">Event Ended</a> <a class="main-btn main-btn-2" target="_blank" href="<?php echo $d4lb; ?>">Register Now (English)</a>
                                        </div>
                                    </div> 
                                </div> 
                            </div>-->
                            
                            <!--<div class="tab-pane fade" id="day-5" role="tabpanel" aria-labelledby="day-5-tab">
                                <div class="event-content pt-40">
                                    <div class="single-event d-md-flex mt-30">
                                        <div class="event-image">
                                            <img src="assets/images/day5-flyer-min.jpg" width="360px"  alt="Event">
                                        </div>
                                        <div class="event-content media-body">
                                            <h4 class="event-title"><?php echo $d5ten; ?></h4>
                                            <p class="text ar"><?php echo $d5tar; ?></p>
                                            <ul class="event-meta">
                                                <li>Start: 8.30 PM (Bahrain Time)</li>
                                                <li>Duration: 1:30 Hours</li>
                                                <li>Free Event</li>
                                            </ul>
                                            <br><a class="main-btn main-btn-2" href="<?php //echo $d5la; ?>">Event Ended</a>
                                        </div>
                                    </div> 
                                </div>
                            </div>-->
                            
                            <!--<div class="tab-pane fade show active" id="day-6" role="tabpanel" aria-labelledby="day-6-tab">
                                <div class="event-content pt-40">
                                    <div class="single-event d-md-flex mt-30">
                                        <div class="event-image">
                                            <img src="assets/images/day6-flyer-min.jpg" width="360px"  alt="Event">
                                        </div>
                                        <div class="event-content media-body">
                                            <h4 class="event-title"><?php echo $d6ten; ?></h4>
                                            <p class="text ar"><?php echo $d6tar; ?></p>
                                            <ul class="event-meta">
                                                <li>Start: 8.30 PM (Bahrain Time)</li>
                                                <li>Duration: 1:30 Hours</li>
                                                <li>Free Event</li>
                                            </ul>
                                            <br><a class="main-btn main-btn-2" target="_blank" href="<?php echo $d6la; ?>">Register Now</a>
                                        </div>
                                    </div> 
                                </div> 
                            </div>-->
                            
                        </div>
                    </div> 
                </div>
            </div> 
        </div> 
    </section>

    <!--====== EVENT SCHEDULE PART ENDS ======-->

    <!--====== FOOTER PART START ======-->

    <section id="footer" class="footer-area bg_cover" style="background-image: url(assets/images/footer.jpg)">
<!--        <div class="footer-subscribe-area pt-120 pb-130">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="footer-subscribe text-center">
                            <h2 class="subscribe-title">Subscribe Now</h2>
                            <div class="subscribe-form mt-45">
                                <form action="#">
                                    <input type="email" placeholder="Enter Your Email">
                                    <button class="main-btn">Subscribe Now</button>
                                </form>
                            </div>
                        </div> 
                    </div>
                </div> 
            </div> 
        </div> 
        
        <div class="footer-widget">
            <div class="container">
                <div class="widget  pt-80 pb-130">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="footer-address mt-40">
                                <h5 class="f-title">Venue Location</h5>
                                <p class="text">18 - 21 DECEMBER, 2022 <br> 51 Francis Street, Cesare Rosaroll, 118 80139 Eventine</p>
                                <a class="contact-link" href="#">Contact Our Authority</a>
                            </div> 
                        </div>
                        <div class="col-lg-6">
                            <div class="footer-contact mt-40">
                                <h5 class="f-title">Social Connection</h5>
                                <p class="text">Don't miss a thing! Receive daily news You should connect social area for Any Proper Updates Anytime</p>
                                <ul class="social">
                                    <li><a href="#"><i class="lni-facebook-filled"></i></a></li>
                                    <li><a href="#"><i class="lni-twitter-original"></i></a></li>
                                    <li><a href="#"><i class="lni-linkedin-original"></i></a></li>
                                    <li><a href="#"><i class="lni-instagram-original"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div> 
                </div> 
            </div> 
        </div> 
-->       
        <div class="footer-copyright">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="copyright text-center">
                            <p class="text">&copy 2021-2022 ICF Bahrain Chapter | D&D <a href="https://mmt.me/" rel="nofollow">MMT.ME</a></p>
                        </div> 
                    </div>
                </div> 
            </div> 
        </div> 
    </section>

    <!--====== FOOTER PART ENDS ======-->
    
    <!--====== BACK TOP TOP PART START ======-->

    <a href="#" class="back-to-top"><i class="lni-chevron-up"></i></a>

    <!--====== BACK TOP TOP PART ENDS ======--> 

    <!--====== PART START ======-->

<!--
    <section class="">
        <div class="container">
            <div class="row">
                <div class="col-lg-">
                    
                </div>
            </div>
        </div>
    </section>
-->

    <!--====== PART ENDS ======-->

    <!-- row -->










    <!--====== jquery js ======-->
    <script src="assets/js/vendor/modernizr-3.6.0.min.js"></script>
    <script src="assets/js/vendor/jquery-1.12.4.min.js"></script>

    <!--====== Bootstrap js ======-->
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/popper.min.js"></script>

    <!--====== Counter Up js ======-->
    <script src="assets/js/waypoints.min.js"></script>
    <script src="assets/js/jquery.counterup.min.js"></script>

    <!--====== Slick js ======-->
    <script src="assets/js/slick.min.js"></script>

    <!--====== Magnific Popup js ======-->
    <script src="assets/js/jquery.magnific-popup.min.js"></script>

    <!--====== Scrolling Nav js ======-->
    <script src="assets/js/jquery.easing.min.js"></script>
    <script src="assets/js/scrolling-nav.js"></script>

    <!--====== Countdown js ======-->
    <script src="assets/js/jquery.countdown.min.js"></script>

    <!--====== wow js ======-->
    <script src="assets/js/wow.min.js"></script>

    <!--====== Ajax Contact js ======-->
    <script src="assets/js/ajax-contact.js"></script>

    <!--====== Main js ======-->
    <script src="assets/js/main.js"></script>

</body>

</html>
